<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.cloudStorageApp"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>

<div class="bootstrap-wrapper">
	<div class="modal-header">
		<h1>
			<cv:msg key="label.restoreOpts" bundle="restore" />
		</h1>
	</div>
	<span class="{{azureDbRestore.serverMessage.type}}"
		data-ng-bind="azureDbRestore.serverMessage.message"></span>
	<form name="restoreForm" class="form-horizontal" novalidate
		data-cv-submit="azureDbRestore.submit()" autocomplete="off">
		<div class="panel">
			<div class="panel-body">
				<div class="form-group">
					<label class="col-xs-12 col-sm-5" for="destinationServer">
						<cv:msg key="label.destinationAccount" bundle="cloudStorageApp" />
					</label>

					<div class="col-xs-12 col-sm-7">
						<cv-isteven-single-select id-name="destinationServer"
							input-model="azureDbRestore.destClientList"
							binding-model="azureDbRestore.restoreData.destClient"
							track-field="clientId" label="clientName"
							tick-property="selected" disable-property="disabled"
							on-change="azureDbRestore.onDestClientChanged()"
							place-holder='<cv:msg key="label.selectDestinationAccount" bundle="capps"/>'
							help-text='<cv:msg key="label.selectDestinationAccount" bundle="capps"/>'
							required="true"> </cv-isteven-single-select>
						<span class="help-block"
							data-ng-show="azureDbRestore.restoreData.destClient && azureDbRestore.instancesLoaded === azureDbRestore.restoreData.destClient.clientId  && !azureDbRestore.restoreData.destInstance">
							{{azureDbRestore.destinationServerError}}
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="azureDbRestore.isCosmosDBAccount" >
					<div class="col-xs-12 col-sm-5">
						<cv-help-text help-label="label.redirectAllContainersToCosmosAccount" help-text="help.redirectAllContainer" />
					</div>

					<div class="col-xs-12 col-sm-7">
						<toggle-control status="azureDbRestore.setDestCosmosDbAccount" data-ng-click="azureDbRestore.setDestCosmosDbAccount = !azureDbRestore.setDestCosmosDbAccount"></toggle-control>
						<div data-ng-if="azureDbRestore.setDestCosmosDbAccount">
							<cv-isteven-single-select id-name="destinationCosmosDbAccounts"
								input-model="azureDbRestore.storageAccountsList"
								binding-model="azureDbRestore.restoreData.destCosmosDbAccount"
								binding-field="name"
								track-field="name" label="name"
								tick-property="selected" disable-property="disabled"
								data-helper-elements="filter"
								on-change="azureDbRestore.onChangeDestCosmosDbAccount(data)"
								place-holder='<cv:msg key="label.selectDestinationCosmosDBAccount" bundle="capps"/>'>
							</cv-isteven-single-select>
						</div>
						<span class="help-block"
							data-ng-show="azureDbRestore.showDestinationCosmosDbError">
							<cv:msg key="error.destinationCosmosDbAccount" bundle="capps" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="azureDbRestore.isCosmosDBAccount">
					<div class="col-xs-12 col-sm-5" >
						<label for="throughput" >
							<cv-help-text help-label="label.adjustThrouhgput" help-text="label.adjustThrouhgputHelp" />
						</label>
					</div>
					<div class="col-xs-12 col-sm-7" >
						<toggle-control status="azureDbRestore.restoreData.adjustThroughput" data-ng-click="azureDbRestore.restoreData.adjustThroughput = !azureDbRestore.restoreData.adjustThroughput"></toggle-control>
						<div data-ng-if="azureDbRestore.restoreData.adjustThroughput">
						<input type="number" id="throughput" name="throughput" min="{{azureDbRestore.minCap}}" max="{{azureDbRestore.maxCap}}" data-ng-model="azureDbRestore.restoreData.throughput" autofocus />
						<cv:msg key='label.azure.throughput.rus' bundle='capps'/>
						<span class="help-block" data-ng-show="!azureDbRestore.isValidThroughput()">
							<cv:msg key="label.numberOutOfRange" bundle="capps"/>
						</span>
						</div>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12 col-sm-5" >
						<label for="noOfStreams">
							<cv-help-text help-label="{{azureDbRestore.noOfStreamsLabel}}" help-text="azureDbRestore.noOfStreamsHelpText"></cv-help-text>
						</label>
					</div>
					<div class="col-xs-12 col-sm-7" >
						<input  type="number" id="noOfStreams" name="noOfStreams" min="1" max="50" step="1" data-ng-model="azureDbRestore.restoreData.noOfStreams" />
						<span class="help-block" data-ng-show="!azureDbRestore.isValidStream()">
							<cv:msg key="error.noOfParallelWriters" bundle="capps" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12 col-sm-5">
						<cv-help-text
							help-label="{{azureDbRestore.overwriteContentLabel}}"
							help-text="azureDbRestore.overwriteContentHelp" />

					</div>
					<div class="col-xs-12 col-sm-7">
						<toggle-control status="azureDbRestore.restoreData.overwrite"
							data-ng-click="azureDbRestore.restoreData.overwrite = !azureDbRestore.restoreData.overwrite"></toggle-control>
					</div>
				</div>

				<cv-kendo-grid cv-grid-options="azureDbRestore.gridOptions" />
			</div>
		</div>

		<div class="modal-footer">
			<button id="cappsRestoreOptionsAzureDb_button_#1759" type="button"
				class="btn btn-default cvBusyOnAjax"
				data-ng-click="azureDbRestore.cancel()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="cappsRestoreOptionsAzureDb_button_#4696"
				class="btn btn-primary cvBusyOnAjax" type="submit">
				<cv:msg key="Submit" bundle="messages" />
			</button>
		</div>
	</form>
</div>
