<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>

<script type="text/ng-template" id="customPopupTemplate.html">
	<a class="custodianSuggestText">
		<span ng-bind-html="match.label | uibTypeaheadHighlight:query" class="crop"></span> 
	</a>
 </script>

<div class="setup-title">
	<h1><cv:msg key="label.restoreOpts" bundle="restore"/></h1>
</div>
<span class="{{restoreCappsCtrl.serverMessage.type}}" data-ng-bind="restoreCappsCtrl.serverMessage.message"></span>
<form name="restoreForm" class="form-horizontal bootstrap-wrapper" novalidate data-cv-submit="restoreCappsCtrl.doRestore()" autocomplete="off">
	<div class="modal-body no-padding">
		
		<!--Restore Destination-->
		<div class="form-group margin-left-10 margin-right-10">
			<label class="col-xs-4 margin-top-15"><cv:msg key="label.restoreoptions.restoreRestination" bundle="office365"/></label>
			<div class="col-xs-8">
				<select id="restoreTo" name="restoreTo"
							data-ng-options="option.value as option.name for option in  restoreCappsCtrl.restoreTypeList "
							data-ng-model="restoreCappsCtrl.restoreType"
							data-ng-change="restoreCappsCtrl.restoreTypeChanged()"	>
				</select>
			</div>
		</div>

		<!--Restore header-->
        <div class="plain-accordion margin-top-10">
            <div class="cv-accordion-header">
                <span class="cv-accordion-text" data-ng-bind="restoreCappsCtrl.restoreAccountMachineLabel"></span>
                <span class="restore-help-text"><i class="k-icon k-i-information margin-right-5"></i>
                    <label data-ng-bind="restoreCappsCtrl.restoreAccountMachineHelpText"></label>                   
                </span>
            </div>
        </div>
		<!--Restore header-->
 		
		<!-- START - RESTORE TO DISK -->
		<div data-ng-if="restoreCappsCtrl.restoreType === 'disk'">
			<!--proxy servers with cloudconnector agent -->
			<div class="form-group margin-left-10 margin-right-10 margin-top-10">
				<label class="col-xs-4 margin-top-15" for="proxyServer"><cv:msg key="label.destHost" bundle="capps"/></label>
				<div class="col-xs-8">
					<select id="proxyServer" name="proxyServer"
							data-ng-model="restoreCappsCtrl.selectedProxyServer"
							data-ng-options="ds as ds.clientName for ds in restoreCappsCtrl.proxyServerList track by ds.clientId"
							data-ng-required="true"
							data-ng-change="restoreCappsCtrl.proxyServerChanged()">
							<option value=""><cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/></option>
					</select>
					<div class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.proxyServer)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.destinationServer" bundle="restore"></cv:msg>
					</div>
				</div>
			</div>

			<!-- For Disk Path -->
			<div class="form-group margin-left-10 margin-right-10">
				<label for="restorePath" class="col-xs-4 margin-top-15"><cv:msg key="label.destPath" bundle="snapArray"/></label>
				<div class="col-xs-8">
					<div class="input-group">
						<input type="text" id="restorePath" name="restorePath"
							data-ng-disabled="!restoreCappsCtrl.selectedProxyServer"
							data-ng-model="restoreCappsCtrl.selectedDiskPath"
							data-ng-required="restoreCappsCtrl.restoreType == restoreCappsCtrl.restoreTypeDisk" />
						<span class="input-group-btn">
							<button type="button" id="cappsRestoreOptions_button_#6726" class="icon-style cv-material-button browse"
								data-ng-disabled="!restoreCappsCtrl.selectedProxyServer"
								data-ng-click="restoreCappsCtrl.openDiskDestinationFolder()">
								<div class="cv-material-button-icon cursor-pointer">
									<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
										<path d="M0 0h24v24H0z" fill="none" />
										<path
											d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z" />
										</svg>
								</div>
								<div class="cv-material-button-tooltip">
									<cv:msg key="Browse" bundle="storage" />
								</div>
							</button>
						</span>
					</div>
					<div class="help-block" data-ng-show="restoreCappsCtrl.isDiskDestinationInfoNeeded() && cv.restoreForm.needsAttention(restoreForm.restorePath)">
						<i class="ion-alert-circled"></i>
						<cv:msg key="error.pathRequired" bundle="restore"/>
					</div>
				</div>
			</div>
		</div>
		<!--RESTORE TO DISK --- END-->

		<!-- START - TO ONE DRIVE -->
		<div data-ng-if="restoreCappsCtrl.restoreType === 'account'">

			<!-- Restore inplace --out-of-place options --START-->
			<div class="margin-left-0 margin-right-0 padding-left-15 padding-right-15">
				<div class="margin-top-10 margin-left-10">
					<cv-radio-group is-vertical="true" radio-model="restoreCappsCtrl.restoreToOriginalLocationRadioVal"
						radio-obj="restoreCappsCtrl.restoreLocationOptions"
						on-click="restoreCappsCtrl._restoreToOriginalLocationRadioValChange(data)">
					</cv-radio-group>
				</div>
			</div>
			<!-- Restore inplace --out-of-place options --END-->

			<!--OneDrive User Account--START-->
			<div class="form-group row margin-top-10 margin-left-25 margin-right-10"
				data-ng-if="!restoreCappsCtrl.restoreToOriginalPath">
				<label class="col-xs-3" for="userAccountInput">
					<i class="k-icon k-i-user margin-right-5"></i>
					<cv:msg key="label.restoreoptions.userAccount" bundle="office365" />
				</label>
			
				<div class="col-xs-9">
					<div class="input-group">
						<input type="text" id="userAccountInput" name="userAccountInput" required
							placeholder={{restoreCappsCtrl.getUserPlaceHolder()}}
							ng-change="restoreCappsCtrl.onUserEmailInputChange($viewValue)"
							ng-model="restoreCappsCtrl.selectedOneDriveUser"
							typeahead-template-url="customPopupTemplate.html"
							typeahead-on-select="restoreCappsCtrl.onUserEmailInputChange()"
							uib-typeahead="userEmailList.email for userEmailList in restoreCappsCtrl.userEmailList | limitTo:6">
			
						<span class="input-group-btn">
							<button type="button" id="userBrowse_btn" class="icon-style cv-material-button browse"
								data-ng-click="restoreCappsCtrl.getOneDriveUsersFromDiscovery()">
								<div class="cv-material-button-icon cursor-pointer">
									<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
										<path d="M0 0h24v24H0z" fill="none" />
										<path
											d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z" />
										</svg>
								</div>
								<div class="cv-material-button-tooltip">
									<cv:msg key="Browse" bundle="storage" />
								</div>
							</button>
						</span>
					</div>
					<div class="help-block"
						data-ng-show="cv.restoreForm.needsAttention(restoreForm.userAccountInput) || restoreCappsCtrl.showInvalidUserError">
						<cv:msg key="error.valid.onedrive.user" bundle="office365" />
					</div>
				</div>
			</div>
			<!--OneDrive User Account--END-->
					
			<!--OneDrive Folder--START-->
			<div class="form-group row margin-top-10 margin-left-25 margin-right-10"
				data-ng-if="!restoreCappsCtrl.restoreToOriginalPath">
				<label class="col-xs-3" for="restoreDestination">
					<i class="fa fa-folder margin-right-5"></i>
					<cv:msg key="label.restoreoptions.oneDriveFolder" bundle="office365" />
				</label>
				<div class="col-xs-9">		
					<div class="input-group">
						<label data-ng-bind="restoreCappsCtrl.selectedOneDriveFolder"></label>
						<span class="input-group-btn" data-ng-disabled="!restoreCappsCtrl.selectedOneDriveUser.length">
							<button type="button" id="browse_folder" class="icon-style cv-material-button browse"
								data-ng-click="restoreCappsCtrl.openODDestinationFolder()">
								<div class="cv-material-button-icon cursor-pointer">
									<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
										<path d="M0 0h24v24H0z" fill="none" />
										<path
											d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z" />
										</svg>
								</div>
								<div class="cv-material-button-tooltip">
									<cv:msg key="Browse" bundle="storage" />
								</div>
							</button>
						</span>
					</div>
				</div>
			</div>
			<!--OneDrive Folder--END-->
			<!--OneDrive User Folder Selection End--END-->


			<!--File Restore Options-->
			<div class="plain-accordion margin-top-10">
				<cv-plain-accordion accordion-label='<cv:msg key="header.filelevel.options" bundle="office365" />'>			
					<div class="margin-left-0 margin-right-0 padding-left-10 padding-right-10">                   
						<div class="form-group row margin-top-10">
							<cv-help-text class="col-xs-3 margin-top-5 margin-left-15" help-label="label.restore.file.exists" help-text="help.restore.file.exists" />
							<div class="col-xs-8">                                         
								<cv-radio-group 
									is-vertical="true" 
									radio-model="restoreCappsCtrl.fileRestoreOptionSelected" 
									radio-obj="restoreCappsCtrl.fileRestoreOptions" 
									on-click="restoreCappsCtrl._fileRestoreOptionChange(data)">
								</cv-radio-group>	               
							</div>                 
						</div>              
						<!--Overwrite data--END-->
					</div>
				</cv-plain-accordion>
			</div>     
			<!--File Restore Options-->

		<!--Advanced restore options -->
        <div class="plain-accordion">
            <cv-plain-accordion accordion-label="header.restoreoptions.advancedOptions">			
				<div class="margin-left-0 margin-right-0 padding-left-10 padding-right-10">
					<!--pseudo servers filtered by cloudapptype -->
					<div class="form-group no-margin">
						<label class="col-xs-4 margin-top-15" for="pseudoServer"><cv:msg key="label.destinationOffice365Client" bundle="office365"/></label>
						<div class="col-xs-8">
							<div data-ng-if="!restoreCappsCtrl.isOneDriveV2">
								<div class="cv-modal-wrapper">
									<select id="pseudoServer" name="pseudoServer"
											data-ng-model="restoreCappsCtrl.selectedPseudoServer"
											data-ng-options="ds as ds.clientName for ds in restoreCappsCtrl.pseudoServerList track by ds.clientId"
											data-ng-required="true"
											data-ng-change="restoreCappsCtrl.pseudoServerChanged()">
											<option value=""><cv:msg key="option.destinationOffice365Client" bundle="office365"/></option>
									</select>
								</div>
							</div>
							<div class="help-block" data-ng-show="!restoreCappsCtrl.selectedPseudoServer">
								<i class="ion-alert-circled"></i>
								<cv:msg key="help.destinationOffice365Client" bundle="office365"/>
							</div>
						</div>
					</div>
				</div>
			</cv-plain-accordion>
        </div>     
		<!--Advanced restore options -->

	</div>
			<!--Restore to User Account/Site/Web/Server --END-->
		<!-- END - TO ONE DRIVE -->
	</div>
	<!--END MODAL BODY -->

	<!--MODAL FOOTER-->
	<div class="modal-footer">
		<button id="cappsRestoreOptions_button_#6069" class="btn btn-default cvBusyOnAjax" type="button" data-ng-click="restoreCappsCtrl.cancelModel()"><cv:msg key="Cancel" bundle="messages" /></button> 
		<button id="cappsRestoreOptions_button_#3191" class="btn btn-primary cvBusyOnAjax" type="submit"><cv:msg key="Submit" bundle="messages"/></button> 
	</div>
</form>
