<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div data-ng-controller = "cappsOrgDetailsSFController as cappsODCtrl">
	<div class="row">
		<span class="server-message {{cappsODCtrl.serverMessage.type}}" data-ng-bind="cappsODCtrl.serverMessage.message"></span>
	</div>
	<div data-ng-if="cappsODCtrl.model.org">
	 	<div class="row">
			<div class="col-xs-12 col-md-6">
				<h1 class='page-title'>{{cappsODCtrl.model.org.entity.instanceName}}</h1>
			</div>
			<div class="col-xs-12 col-md-6">
				<a class="page-action-item" data-ng-click="cappsODCtrl.deleteOrg()"><cv:msg key="Delete" bundle="messages"/></a>
			    <a class="page-action-item" data-ng-click="cappsODCtrl.dataMasking()"><cv:msg key="label.dataMasking" bundle="capps"/></a>
				<a class="page-action-item" data-ng-if="cappsODCtrl.model.org.subclientCommonProp.lastBackupTime" href="{{cappsODCtrl.restoreUrl}}"><cv:msg key="label.restore" bundle="capps"/></a>
				<a class="page-action-item" data-ng-click="cappsODCtrl.backup()"><cv:msg key="action.backup" bundle="capps"/></a>
				<a class="page-action-item" data-ng-if="cappsODCtrl.model.org.subclientCommonProp.lastBackupTime" data-ng-click="cappsODCtrl.compare()"><cv:msg key="action.compare" bundle="capps"/></a>
				<a class="page-action-item" href="{{cappsODCtrl.backupHistoryUrl}}"><cv:msg key="label.BackupHistory" bundle="clients" /></a>
				<a class="page-action-item" data-ng-click="cappsODCtrl.goEdit()"><cv:msg key="action.edit" bundle="capps"/></a>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-md-6">
				<cv-tile-component data-ac-id="cappsOrgDetailsSF-header_accountDetails-capps" data-title='<cv:msg key="header.accountDetails" bundle="capps" />' >
					<ul class="list-style-secondary">
						<cv-tile-label-value label='<cv:msg key="label.salesforceLoginUrl" bundle="capps"/>' value="{{cappsODCtrl.model.org.instanceProp.endpoint}}" ></cv-tile-label-value>
						<cv-tile-label-value label='<cv:msg key="label.salesforceOrgId" bundle="capps"/>' value="{{cappsODCtrl.model.org.instanceProp.sfOrgID}}" ></cv-tile-label-value>
						<cv-tile-label-value label='<cv:msg key="label.userName" bundle="servers"/>' value="{{cappsODCtrl.model.org.backupsetProp.userPassword.userName}}" ></cv-tile-label-value>
						<cv-tile-label-value label='<cv:msg key="label.consumerKey" bundle="capps"/>' value="{{cappsODCtrl.model.org.instanceProp.consumerId}}" ></cv-tile-label-value>
					</ul>
				</cv-tile-component>
				<cv-tile-component data-ac-id="cappsOrgDetailsSF-header_backupOptions-capps" data-title='<cv:msg key="header.backupOptions" bundle="capps" />' >
					<ul class="list-style-secondary">
						<cv-tile-label-value label='<cv:msg key="label.backupPlan" bundle="capps"/>' value="{{cappsODCtrl.model.org.planEntity.planName}}" ></cv-tile-label-value>
						<cv-tile-label-value data-ng-if="cappsODCtrl.model.org.instanceProp.filesPerBackup" label='<cv:msg key="label.filesPerBackup" bundle="capps"/>' value="{{cappsODCtrl.model.org.instanceProp.filesPerBackup}} %" ></cv-tile-label-value>
						
					</ul>
				</cv-tile-component>
			</div>
			<div class="col-xs-12 col-md-6">
				<cv-schedule-tile show-edit="false" scheduleIdentifierList="scheduleIdentifierList" subclient-id="subclientId" is-schedule-editable="false"></cv-schedule-tile>
				<cv-capps-content-tile subclient-id="cappsODCtrl.model.org.entity.subclientId"/>
			</div>
		</div>
		<div class="row">
				<!-- Using showFirstJobSection to refresh this section without modifying Job Controller-->
				<div data-ng-controller="jobListPerClientController" class="col-xs-12" data-ng-if="!cappsODCtrl.showSecondJobSection">
					<div data-ng-init="cappsODCtrl.jobControllerLoaded()"></div>
					<data-ng-include src="appUtil.appRoot + 'jobs/partials/jobs.jsp'"> </data-ng-include>
				</div>
				<div data-ng-controller="jobListPerClientController" class="col-xs-12" data-ng-if="cappsODCtrl.showSecondJobSection">
					<div data-ng-init="cappsODCtrl.jobControllerLoaded()"></div>
					<data-ng-include src="appUtil.appRoot + 'jobs/partials/jobs.jsp'"> </data-ng-include>
				</div>
		</div>
	</div>
</div>