<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1 > <cv:msg key="label.inlineEdit" bundle="messagesJs"/> {{::ddbrEdit.data.tableName}}</h1>
	</div>
	<span class="{{ddbrEdit.serverMessage.type}}" data-ng-bind="ddbrEdit.serverMessage.message"></span>
	<form name="ddbrEditForm" class="form-horizontal" novalidate data-cv-submit="ddbrEdit.ok()" autocomplete="off">
		<div class="panel">
		<div class="panel-body">

			<div class="form-group" data-ng-if="ddbrEdit.cloudAppType !== '32'">
				<label for="destRegion" class="col-xs-12 col-sm-5">
					<cv:msg key="label.destinationRegion" bundle="capps"/>
				</label>
				<div class="col-xs-12 col-sm-7">
					<cv-isteven-single-select id-name="destRegion"
								input-model="ddbrEdit.regionList"
								binding-model="ddbrEdit.data.destRegionName"
								binding-field="name"
								track-field="name"
								label="displayName"
								tick-property="selected"
								place-holder='<cv:msg key="error.region" bundle="ediscovery"/>'
								help-text='<cv:msg key="error.region" bundle="ediscovery"/>'
								required = "true">
					</cv-isteven-single-select>
				</div>
			</div>

			<!-- Azure table storage -->
			<div class="form-group" data-ng-if="ddbrEdit.cloudAppType === '32'">
				<label for="destStorageAccount" class="col-xs-12 col-sm-5">
					<cv:msg key="label.destinationStorageAccount" bundle="capps"/>
				</label>
				<div class="col-xs-12 col-sm-7">
					<cv-isteven-single-select id-name="destStorageAccount"
								input-model="ddbrEdit.regionList"
								binding-model="ddbrEdit.data.destStorageAccountName"
								binding-field="name"
								track-field="name"
								label="name"
								tick-property="selected"
								place-holder='<cv:msg key="error.storageAccount" bundle="ediscovery"/>'
								help-text='<cv:msg key="error.storageAccount" bundle="ediscovery"/>'
								required = "true">
					</cv-isteven-single-select>
				</div>
			</div>

			<div class="form-group">
				<label for="destTable" class="col-xs-12 col-sm-5">
					<cv:msg key="label.destinationTable" bundle="capps"/>
				</label>
				<div class="col-xs-12 col-sm-7">
					<input name="destTable" type="text" data-ng-model="ddbrEdit.data.destTableName" required/>
					<span class="help-block" data-ng-show="cv.ddbrEditForm.needsAttention(ddbrEditForm.destTable)">
						<cv:msg key="error.destinationTable" bundle="capps"/>
					</span>
				</div>
			</div>
		</div>
		</div>
		<div class="modal-footer">
			<button id="cappsEditRestoreTableDynamoDb_button_#0925" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="ddbrEdit.cancel()"> 
				<cv:msg key="Cancel" bundle="messages"/>
			</button>
			<button id="cappsEditRestoreTableDynamoDb_button_#4714" class="btn btn-primary cvBusyOnAjax" type="submit" > 
				<cv:msg key="OK" bundle="messages"/>
			</button>
		</div>
	</form>
</div>
