<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
</script>

<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1 > <cv:msg key="label.editAuthentication" bundle="capps"/></h1>
	</div>
	<span class="{{EditAmazonCred.serverMessage.type}}" data-ng-bind="EditAmazonCred.serverMessage.message"></span>
	<form name="EditAmazonCredForm" class="form-horizontal" novalidate data-cv-submit="EditAmazonCred.submit()" autocomplete="off">
		<div class="panel">
			<div class="panel-body">
						<div class="form-group" data-ng-if="!EditAmazonCred.isSqlAmazon && !EditAmazonCred.isAzureDb">
							<div class="col-xs-12">
								<div class="multiple-radio-group">
									<label for="authentication1"><input type="radio" data-ng-model="EditAmazonCred.authenticationType" value="IAMRole" name="authenticationType" id="authentication1" data-ng-change="EditAmazonCred.changeAuthenticationTypeForAmazon()" />
									<span class="block-indent"><cv:msg key="label.IAMRole" bundle="servers" /></span></label>
								</div>
								<div class="multiple-radio-group">
									<label for="authentication2"><input type="radio" data-ng-model="EditAmazonCred.authenticationType" value="AccessAndSecretKey" name="authenticationType" id="authentication2" data-ng-change="EditAmazonCred.changeAuthenticationTypeForAmazon()" />
									<span class="block-indent"><cv:msg key="label.AccessSecretKey" bundle="servers" /></span></label>
								</div>
								<div class="multiple-radio-group">
									<label for="stsRole"><input type="radio" data-ng-model="EditAmazonCred.authenticationType" value="STSRole" name="authenticationType" id="stsRole" data-ng-change="EditAmazonCred.changeAuthenticationTypeForAmazon()" />
									<span class="block-indent"><cv:msg key="label.STSRole" bundle="servers"/></span></label>
								</div>
							</div>
						</div>
						<div class="form-group" data-ng-if="EditAmazonCred.authenticationType==='AccessAndSecretKey' || EditAmazonCred.authenticationType==='STSRole'">
							<label class="col-xs-12 col-sm-5" for="accessKey">
								<span data-ng-show="EditAmazonCred.authenticationType==='AccessAndSecretKey'" > <cv:msg key="label.accessKey" bundle="servers" /> </span>
								<span data-ng-hide="EditAmazonCred.authenticationType==='AccessAndSecretKey'" > <cv:msg key="label.roleArn" bundle="servers" /> </span>
							</label>
							<div class="col-xs-12 col-sm-7">
								<input type="text" name="accessKey" id="accessKey" data-ng-model="EditAmazonCred.accessKey" data-ng-required="EditAmazonCred.authenticationType==='AccessAndSecretKey' || EditAmazonCred.authenticationType==='STSRole'" />
								<span class="help-block" data-ng-show="cv.EditAmazonCredForm.needsAttention(EditAmazonCredForm.accessKey)">
									<span data-ng-show="EditAmazonCred.authenticationType==='AccessAndSecretKey'" > <cv:msg key="error.accessKey" bundle="servers" /> </span>
									<span data-ng-hide="EditAmazonCred.authenticationType==='AccessAndSecretKey'" > <cv:msg key="error.roleArn" bundle="servers" /> </span>
								</span>
							</div>
						</div>
						<div class="form-group" data-ng-if="EditAmazonCred.authenticationType==='AccessAndSecretKey'">
							<label class="col-xs-12 col-sm-5" for="secretKey"><cv:msg key="label.secretKey" bundle="servers" /></label>
							<div class="col-xs-12 col-sm-7">
								<input type="password"
										name="secretKey"
										id="secretKey"
										data-ng-model="EditAmazonCred.secretKey"
										ng-required="!EditAmazonCred.hasAccessKeySaved"
										placeholder="{{EditAmazonCred.hasAccessKeySaved? EditAmazonCred.cvLoc('label.passwordKeep'):'' }}"
										autoCompleteType="disable" autocomplete="new-password"
										data-ng-disabled="EditAmazonCred.authenticationType==='IAMRole'" />
								<span class="help-block" data-ng-show="cv.EditAmazonCredForm.needsAttention(EditAmazonCredForm.secretKey)"><cv:msg key="error.secretKey" bundle="servers" /></span>
							</div>
						</div>

						<div data-ng-if="EditAmazonCred.isAzureDb">
							<div class="form-group">
								<label class="col-xs-12 col-sm-10" for="isManagedIdentity">
									<toggle-control status="EditAmazonCred.azureCreds.isManagedIdentity" data-ng-click="EditAmazonCred.azureCreds.isManagedIdentity = !EditAmazonCred.azureCreds.isManagedIdentity"></toggle-control>
									<span> <cv:msg key="label.managedSvcIdentity" bundle="servers" /> </span>
								</label>
							</div>

							<div class="form-group">
								<label class="col-xs-12 col-sm-5" for="subscriptionId"><cv:msg key="label.subscriptionId" bundle="servers" /></label>
								<div class="col-xs-12 col-sm-7">
									<input type="text"
											name="subscriptionId"
											id="subscriptionId"
											data-ng-model="EditAmazonCred.azureCreds.subscriptionId"
											ng-required="true"	/>
									<span class="help-block" data-ng-show="cv.EditAmazonCredForm.needsAttention(EditAmazonCredForm.subscriptionId)"><cv:msg key="error.subscriptionId" bundle="servers" /></span>
								</div>
							</div>

							<div class="form-group" data-ng-if="!EditAmazonCred.azureCreds.isManagedIdentity">
								<label class="col-xs-12 col-sm-5" for="tenantId"><cv:msg key="label.tenantId" bundle="servers" /></label>
								<div class="col-xs-12 col-sm-7">
									<input type="text"
											name="tenantId"
											id="tenantId"
											data-ng-model="EditAmazonCred.azureCreds.tenantId"
											ng-required="true"	/>
									<span class="help-block" data-ng-show="cv.EditAmazonCredForm.needsAttention(EditAmazonCredForm.tenantId)"><cv:msg key="error.tenantId" bundle="servers" /></span>
								</div>
							</div>

							<div class="form-group" data-ng-if="!EditAmazonCred.azureCreds.isManagedIdentity">
								<label class="col-xs-12 col-sm-5" for="applicationId"><cv:msg key="label.applicationId" bundle="servers" /></label>
								<div class="col-xs-12 col-sm-7">
									<input type="text"
											name="applicationId"
											id="applicationId"
											data-ng-model="EditAmazonCred.azureCreds.applicationId"
											ng-required="true"	/>
									<span class="help-block" data-ng-show="cv.EditAmazonCredForm.needsAttention(EditAmazonCredForm.applicationId)"><cv:msg key="error.applicationId" bundle="servers" /></span>
								</div>
							</div>

							<div class="form-group" data-ng-if="!EditAmazonCred.azureCreds.isManagedIdentity">
								<label class="col-xs-12 col-sm-5" for="applicationPassword"><cv:msg key="label.applicationPassword" bundle="servers" /></label>
								<div class="col-xs-12 col-sm-7">
									<input type="password"
											name="applicationPassword"
											id="applicationPassword"
											data-ng-model="EditAmazonCred.azureCreds.applicationPassword"
											placeholder="{{EditAmazonCred.cvLoc('label.passwordKeep')}}"
											autoCompleteType="disable" autocomplete="new-password"/>
									<span class="help-block" data-ng-show="cv.EditAmazonCredForm.needsAttention(EditAmazonCredForm.applicationPassword)"><cv:msg key="error.applicationPassword" bundle="servers" /></span>
								</div>
							</div>
						</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="cappsEditAmazonCredentials_button_cancel" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="EditAmazonCred.cancel()">
				<cv:msg key="Cancel" bundle="messages"/>
			</button>
			<button id="cappsEditAmazonCredentials_button_submit" class="btn btn-primary cvBusyOnAjax" type="submit" >
				<cv:msg key="OK" bundle="messages"/>
			</button>
		</div>
	</form>
</div>