<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1 > {{dynamoDbCS.headerText}}</h1>
	</div>
	<span class="{{dynamoDbCS.serverMessage.type}}" data-ng-bind="dynamoDbCS.serverMessage.message"></span>
	<form name="dynamoDbCSForm" class="form-horizontal" novalidate data-cv-submit="dynamoDbCS.submit()" autocomplete="off">
		<div class="panel">
			<div class="panel-body">
				<div class="form-group">
					<label for="subclientName" class="col-xs-12 col-sm-5" >
						<cv:msg key="label.name" bundle="clients" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="text" name="subclientName" id="subclientName"
								data-ng-model="dynamoDbCS.model.subclientName" required autofocus />
						<span class="help-block" data-ng-show="cv.dynamoDbCSForm.needsAttention(dynamoDbCSForm.subclientName)">
							<cv:msg key="error.subclientName" bundle="clients" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12">
						<cv-entity-plan-policy-select data-ng-if="dynamoDbCS.planPolicyModel" data-cv-model="dynamoDbCS.planPolicyModel"
								data-cv-app-id="dynamoDbCS.entity.applicationId" data-cv-client-id="dynamoDbCS.entity.clientId" data-cv-wrapper-class="'form-group row'"
								no-bootstrap-wrapper-class="true"
								data-cv-label-class="'col-xs-12 col-sm-5'" data-cv-select-class="'col-xs-12 col-sm-7'"
								cv-hide-policy-toggle-option="true">
						</cv-entity-plan-policy-select>
					</div>
				</div>

				<div class="form-group" data-ng-if="dynamoDbCS.showStreams">
					<label for="numberBackupStreams" class="col-xs-12 col-sm-5" >
						{{dynamoDbCS.noOfBackupStreams}}
					</label>
					<div class="col-xs-12 col-sm-7">
						<input id="numberBackupStreams" name="numberBackupStreams"
								 required type="number" data-ng-model="dynamoDbCS.model.numberOfBackupStreams" min="1" max="100" data-ng-maxlength="3" />
						<span class="help-block" data-ng-show="cv.dynamoDbCSForm.needsAttention(dynamoDbCSForm.numberBackupStreams)">
							<cv:msg key="error.numberBackupStreams" bundle="oracle" />
						</span>
					</div>
				</div>
				<cv-capps-optional-capacity data-ng-if="dynamoDbCS.showReadCapacity" enable="dynamoDbCS.model.enableAdjustReadCapacity"
							capacity="dynamoDbCS.model.adjustReadCapacity" min="1" max="{{dynamoDbCS.CAPPS_CONSTANTS.AMAZON_DYNAMODB_CONSTANTS.MAX_TEMP_READ_CAPACITY}}"
							label='<cv:msg key="label.adjustReadCapacity" bundle="capps"/>'
							unit-label='<cv:msg key="label.units" bundle="capps"/>'
							tooltip-label='<cv:msg key="label.adjustReadCapactiyHelp" bundle="capps"/>'/>
			</div>
			<cv-capps-browse-content hide-search="true" show-title="true" entity="dynamoDbCS.entity"  selected-content="dynamoDbCS.selectedContent" instance-type="dynamoDbCS.cloudAppsType"/>
		</div>
		<div class="modal-footer">
			<button id="cappsCreateSubclientDynamoDb_button_#5366" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="dynamoDbCS.cancel()">
				<cv:msg key="Cancel" bundle="messages"/>
			</button>
			<button id="cappsCreateSubclientDynamoDb_button_#9802" class="btn btn-primary cvBusyOnAjax" type="submit" data-ng-disabled="!dynamoDbCS.selectedContent || dynamoDbCS.selectedContent.length == 0">
				<cv:msg key="Save" bundle="messages"/>
			</button>
		</div>
	</form>
</div>
