<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvEnum name="App.CloudAppsInstanceType"></cv:cvEnum>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.gsuite"></cv:cvMessages>
</script>
<div data-ng-controller="cappsClientGAPIController as clGAPIctrl">
	<div class="row">
		<div class="col-md-12">
			<cv-changename obj='clGAPIctrl.changeNameObj' service-method='changeServerName.do' class="float-left"></cv-changename>
			<%-- This is the page message to display any error --%>
			<span class="server-message {{clGAPIctrl.pageMessage.type}} text-center">{{clGAPIctrl.pageMessage.message}}</span>
			<cv:comp name="show.delete"><span data-ng-if="clGAPIctrl.retrievedClientDetails"><a href="" class="page-action-item"  data-ng-click="clGAPIctrl.deleteServer()"><cv:msg key="action.delete" bundle="capps" /></a></span></cv:comp>
			<span data-ng-if="clGAPIctrl.clientDetails"><a href="" class="page-action-item"  data-ng-click="clGAPIctrl.serverJobs()"><cv:msg key="header.jobs" bundle="capps" /></a></span>
		</div>
	</div>
	<div class="row">
		<div class="col-md-6">
			<cv-tile-component data-ac-id="cappsClientDetailsGM-header_general-capps" data-title='<cv:msg key="header.general" bundle="capps"/>' loader="(clGAPIctrl.clientName && clGAPIctrl.model)" data-ng-show="clGAPIctrl.model">
				<ul class="group list-style-secondary toggle-height">
					<li class="group"><span class="pageDetailColumn">
						<cv:msg key="label.clientName" bundle="capps" /></span>
						<span class="pageDetailColumn" data-ng-bind="clGAPIctrl.changeNameObj.name"></span>
					</li>
					<li class="group" data-ng-if="(clGAPIctrl.model.cloudAppType === clGAPIctrl.cloudAppTypeGoogleDrive) || (clGAPIctrl.model.cloudAppType === clGAPIctrl.cloudAppTypeGoogleMail)">
						<span class="pageDetailColumn"><cv:msg key="label.emailId" bundle="capps" /></span>
						<span class="pageDetailColumn" data-ng-bind="clGAPIctrl.model.emailId"></span>
					</li>
					<li class="group" data-ng-if="clGAPIctrl.model.cloudAppType === clGAPIctrl.cloudAppTypeOneDrive">
						<span class="pageDetailColumn"><cv:msg key="label.onedrive.clientId" bundle="capps" /></span>
						<span class="pageDetailColumn" data-ng-bind="clGAPIctrl.model.instancePropOneDriveClientId"></span>
					</li>
					<!-- <li class="group" data-ng-if="clGAPIctrl.model.cloudAppType === clGAPIctrl.cloudAppTypeOneDrive">
						<span class="pageDetailColumn"><cv:msg key="label.onedrive.clientSecret" bundle="capps" /></span>
						<span class="pageDetailColumn" data-ng-bind="clGAPIctrl.model.instancePropOneDriveSecretKey"></span>
					</li> -->
					<li class="group" data-ng-if="clGAPIctrl.model.cloudAppType === clGAPIctrl.cloudAppTypeOneDrive">
						<span class="pageDetailColumn"><cv:msg key="label.azureDirectoryID" bundle="messages" /></span>
						<span class="pageDetailColumn" data-ng-bind="clGAPIctrl.model.instancePropOneDriveTenant"></span>
					</li>
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.data.autoDiscover" bundle="capps"/></span>
						<span class="pageDetailColumn">
							<toggle-control class="{{clGAPIctrl.autoDiscoverDisplay}}" status="clGAPIctrl.autoDiscoverDisplay" data-ng-click="clGAPIctrl.manageAutoDiscover()" title="Enable/disable <cv:msg key='label.data.autoDiscover' bundle='capps' />"></toggle-control>
						</span>
					</li>
			</ul>
			<div class="page-details-box-links">
                <a href="" data-ng-click="clGAPIctrl.showEditServerDialog()"><cv:msg key="action.edit.only" bundle="capps" />
                </a>
            </div>
			</cv-tile-component>
			<cv-activity-control-component data-ac-params="clGAPIctrl.acParams"></cv-activity-control-component>
			<cv-tile-component data-ac-id="cappsClientDetailsGM-header_proxy-capps" data-title='<cv:msg key="header.accessNode" bundle="capps"/>' loader="clGAPIctrl.model.backupClient">
					<ul class="group list-style-secondary">
						<li class="group">
							<span class="pageDetailColumn">{{clGAPIctrl.model.backupClient.clientName}}</span>
						</li>
					</ul>
					<div class="page-details-box-links" >
		                <a href="" data-ng-click="clGAPIctrl.showEditProxyDialog()"><cv:msg key="action.edit.only" bundle="capps" />
		                </a>
		            </div>
			</cv-tile-component>
		</div>
		<div class="col-md-6">
			<cv-tile-component data-ac-id="cappsClientDetailsGM-header_ContentIndex-capps" data-title='<cv:msg key="header.ContentIndex" bundle="capps"/>' loader="clGAPIctrl.onlineContentIndex">
                 <ul class="list-style-secondary toggle-height" data-ng-show="clGAPIctrl.onlineContentIndex">
                    <li class="group">
                        <span class="pageDetailColumn"><cv:msg key="label.ContentIndex" bundle="capps"/></span>
                        <span class="pageDetailColumn">
                            <toggle-control class="{{clGAPIctrl.onlineContentIndex}}" status="clGAPIctrl.onlineContentIndex" data-ng-click="clGAPIctrl.manageContentIndexing()" title="Enable/disable <cv:msg key='label.ContentIndex' bundle='capps' />"></toggle-control>
                        </span>
                    </li>
                </ul>
            </cv-tile-component>
		  	<cv-analytics-plan-component data-ng-show="clGAPIctrl.isAnalyticsEnabled()" datasource-type="clGAPIctrl.oneDriveDataSourceType" client-id="clGAPIctrl.clientId" client-guid="clGAPIctrl.clientGUID" enable-data-analysis="clGAPIctrl.enableDataAnalysis" ></cv-analytics-plan-component>
            
			<cv-client-plan-component data-ng-show="clGAPIctrl.clientId" client-id="clGAPIctrl.clientId" plan-id="clGAPIctrl.planId" plan-entity="clGAPIctrl.planEntity" app-id="clGAPIctrl.appId"></cv-client-plan-component>
			<span data-ng-if="clGAPIctrl.formattedSecurityAssociations">
				<cv-security-component entity-type='clGAPIctrl.entityType' generic-entity='clGAPIctrl.genericEntity' associations='clGAPIctrl.formattedSecurityAssociations' associations-loaded='clGAPIctrl.associationsLoaded' data-show-Owners='true'>
				</cv-security-component>
			</span>
		</div>
	</div>
	<div class="row">
		<div class="col-md-12">
			<cv-grid cv-grid-options="clGAPIctrl.gridOptions"></cv-grid>
		</div>
	</div>
</div>