<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<div data-ng-controller="cappsClientConfigAnalyticsController as cappsClConfigAnalyticsCtrl">
<div class="setup-title">
	<h1>{{cappsClConfigAnalyticsCtrl.analyticsLabelText}}</h1>
</div>
<div class="setup-content">
	<div class="{{cappsClConfigAnalyticsCtrl.serverMessage.type}} serverMessage">{{cappsClConfigAnalyticsCtrl.serverMessage.message}}</div>
	<form id="editAnalyticsForm" name="editAnalyticsForm" data-cv-submit="cappsClConfigAnalyticsCtrl.saveAnalyticsForClient()" novalidate autocomplete="off">
	<!-- For VSA, show the plan list combo only if it has a plan associated -->
	<div class="global-options remove-border-padding" data-ng-if="!cappsClConfigAnalyticsCtrl.isVSA || (cappsClConfigAnalyticsCtrl.isVSA && cappsClConfigAnalyticsCtrl.planList && cappsClConfigAnalyticsCtrl.planList.length > 0)">
		<label  for="plan"><cv:msg key="label.plan" bundle="capps"/>
			<div class="company-multi-select">
				<isteven-multi-select id="cappsClientConfigAnalytics_isteven-multi-select_#4587" 
					input-model="cappsClConfigAnalyticsCtrl.planList"
					output-model="cappsClConfigAnalyticsCtrl.selectedPlanList"
					button-label="planName"
					item-label="planName"
					tick-property="selected"
					selection-mode="single"
					class="isteven-multi-select user-group-select single-select"
					helper-elements="filter"
					search-limit="10"
					max-labels="1"
					translation="cappsClConfigAnalyticsCtrl.localLang"
					on-item-click="cappsClConfigAnalyticsCtrl.changePlan(cappsClConfigAnalyticsCtrl.selectedPlanList)">
				</isteven-multi-select>
			</div>
		</label>
	</div>
	<!-- For VSA, show the configure dc plan link if there is no DC plan associated -->
	<div class="global-options remove-border-padding margin-top-20" data-ng-show="cappsClConfigAnalyticsCtrl.isVSA && cappsClConfigAnalyticsCtrl.planList && cappsClConfigAnalyticsCtrl.planList.length === 0">
		<a href="" data-ng-click="cappsClConfigAnalyticsCtrl.configureDCPlan()" 
			data-ng-class="{'disabled': cappsClConfigAnalyticsCtrl.disableAutoConfigureBtn}">
			<cv:msg key="label.configureDCPlan" bundle="capps" />
		</a> 
	</div>
	
	<div class="button-container">
		<button id="cappsClientConfigAnalytics_button_#0219" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cappsClConfigAnalyticsCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
		<button id="cappsClientConfigAnalytics_button_#3040" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="action.save" bundle="profiles"/></button> 
	</div>
	</form>
</div>