<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="modal-header">
		<h1>{{cappsACR.headerText}}</h1>
	</div>
	
	<form name="addContentRuleForm" novalidate cv-submit="cappsACR.submit()" autocomplete="off" >
		<div>
	
			<span class="{{cappsACR.serverMessage.type}} serverMessage">{{cappsACR.serverMessage.message}}</span>
			
			<div class="form-group">
				<label class="col-xs-12 col-sm-5" for="ruleType">
					<cv:msg key="label.selectRule" bundle="collectionsJs"/>
				</label>
				
				<div class="col-xs-12 col-sm-7">
				
					<cv-isteven-single-select 
						id-name="ruleType"
						input-model="cappsACR.editor.ruleTypeList"
						binding-model="cappsACR.editor.ruleType"
						label="displayName"
						track-field="value"
						tick-property="selected"
						on-change="cappsACR.updateOperators()"
						required="true">
					</cv-isteven-single-select>
				</div>
			</div>
			
			<div class="form-group" data-ng-if="cappsACR.editor.ruleType.isKeyValuePair">
				<label class="col-xs-12 col-sm-5" for="keyString">
						{{cappsACR.cvLoc(cappsACR.editor.ruleType.keyLabelLoc)}}
				</label>
				<div class="col-xs-12 col-sm-7">
					<input type="text"
						id="keyString"
						name="keyString"
						ng-model="cappsACR.editor.keyString"
						required
						spellcheck="false" />
					<span class="help-block" data-ng-show="cv.addContentRuleForm.needsAttention(addContentRuleForm.keyString);">
						{{cappsACR.cvLoc(cappsACR.editor.ruleType.keyHelpLoc)}}
					</span>
				</div>
			</div>
			
			<div class="form-group">
				<label class="col-xs-12 col-sm-5" for="matchesRule">
					<cv:msg key="label.matchesRule" bundle="collectionsJs" />
				</label>
				<div class="col-xs-12 col-sm-7">
					<cv-isteven-single-select 
						id-name="matchesRule"
						input-model="cappsACR.editor.operatorList"
						binding-model="cappsACR.editor.operator"
						label="displayName"
						track-field="value"
						tick-property="selected"
						required="true">
					</cv-isteven-single-select>
				</div>
			</div>
			
			<div class="form-group">
				<label class="col-xs-12 col-sm-5" for="ruleName">
					<span data-ng-if="!cappsACR.editor.ruleType.isKeyValuePair">
						<cv:msg key="label.ruleName" bundle="collectionsJs" />
					</span>
					<span data-ng-if="cappsACR.editor.ruleType.isKeyValuePair">
						{{cappsACR.cvLoc(cappsACR.editor.ruleType.valueLabelLoc)}}
					</span>
				</label>
				<div class="col-xs-12 col-sm-7">
					<input type="text"
						id="ruleName"
						name="ruleName"
						ng-model="cappsACR.editor.ruleString"
						required
						spellcheck="false" />
					<span data-ng-if="!cappsACR.editor.ruleType.isKeyValuePair" class="help-block" data-ng-show="cv.addContentRuleForm.needsAttention(addContentRuleForm.ruleName);" >
						<cv:msg key="error.name" bundle="messagesJs"/>
					</span> 
					<span data-ng-if="cappsACR.editor.ruleType.isKeyValuePair" class="help-block" data-ng-show="cv.addContentRuleForm.needsAttention(addContentRuleForm.ruleName);">
						{{cappsACR.cvLoc(cappsACR.editor.ruleType.valueHelpLoc)}}
					</span>
				</div>
			</div>
			

		</div>
		
		
		<div class="modal-footer">
			<button id="cappsAddContentRule_button_#4122" type="button" class="btn btn-default" data-ng-click="cappsACR.cancel()"> 
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="cappsAddContentRule_button_#0894" type="submit" class="btn btn-primary cvBusyOnAjax"> 
				<cv:msg key="OK" bundle="messages" />
			</button>
		</div>
	</form>
</div>