<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.gsuite"></cv:cvMessages>
	<cv:cvEnum name="App.CloudAppsInstanceType"></cv:cvEnum>
</script>
<div data-ng-controller="cappsClientConfigGAPIController as cAppServCtrl">
			<div class="setup-title" >
				<h1 data-ng-show="cAppServCtrl.showLoading">{{cAppServCtrl.modalTitle}}</h1>
			</div>
		<div class="setup-content server-plan medium-width">
				<span data-cv-loading-spinner data-ng-model="cAppServCtrl.showLoading"></span>
<!-- 			data-ng-if="!cAppServCtrl.isSetup" -->
			<div data-ng-show="cAppServCtrl.showLoading">
				<p class="{{cAppServCtrl.addCAppServerMessage.type}} serverMessage">{{cAppServCtrl.addCAppServerMessage.message}}</p>
				<p class="serverMessage">{{cAppServCtrl.clientsPresentMessage.message}}</p>
				<p class="text-center"><a data-ng-click="cAppServCtrl.showAppForm()" data-ng-show="cAppServCtrl.hideForm"><cv:msg key="label.addNewCloudappApp" bundle="capps"/></a></p>
				<form class="bootstrap-wrapper form-horizontal" name="addCAppServerForm" novalidate data-cv-submit="cAppServCtrl.addCAppServer(cAppServCtrl.serverAdded)" autocomplete="off" data-ng-hide="cAppServCtrl.hideForm">
						<div class="panel panel-default">
						<div class="panel-body">
						<!-- App Type Selection -->
						<div class="form-group margin-bottom-20">
							<label class="col-xs-12 col-md-4 col-lg-4" for="gsuiteApps"><cv:msg
									key="label.applicationType" bundle="gsuite" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								 <isteven-multi-select id="addCAppClientContentGAPI_isteven-multi-select_#5127" 
											input-model="cAppServCtrl.gSuiteApps"
										    output-model="cAppServCtrl.selectedGSuiteApp"
										    button-label="app"
											item-label="app"
											directive-id="'gsuiteApps'"
										    selection-mode="single"
										    helper-elements="filter"
										    max-labels="1"
										    on-item-click="cAppServCtrl.processAppSelection()"
										    tick-property="selected"
										    translation="cAppServCtrl.localLang">
								</isteven-multi-select>
							</div>
						</div>
						<!-- Connection Details Start-->
						<h4 class="margin-0 margin-bottom-10"><cv:msg key="label.cAppClientConnDet" bundle="capps" /></h4>
						<div>
							<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="emailId"><cv:msg key="label.emailId" bundle="capps" /></label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input type="text" name="emailId" id="emailId" data-ng-pattern="cAppServCtrl.emailPattern" data-ng-model="cAppServCtrl.model.emailId" required />
									
									<span class="help-block" data-ng-show="addCAppServerForm.emailId.$error.required && cv.addCAppServerForm.needsAttention(addCAppServerForm.emailId)"><cv:msg key="error.invalidEmailId" bundle="capps" /></span>
									<span class="help-block" data-ng-show="addCAppServerForm.emailId.$error.pattern && cv.addCAppServerForm.needsAttention(addCAppServerForm.emailId)"><cv:msg key="error.invalidEmailId" bundle="capps" /></span>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="appClientId"><cv:msg key="label.appClientId" bundle="capps" /></label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input type="text" id="appClientId" name="appClientId" data-ng-model="cAppServCtrl.model.appClientId" required />
									<span class="help-block" data-ng-show="cAppServCtrl.model && cv.addCAppServerForm.needsAttention(addCAppServerForm.appClientId)"><cv:msg key="error.appClientId" bundle="capps" /></span>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="appEmailId"><cv:msg key="label.appEmailId" bundle="capps" /></label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input type="text" name="appEmailId" id="appEmailId" data-ng-pattern="cAppServCtrl.emailPattern" data-ng-model="cAppServCtrl.model.appEmailId" required />
									
									<span class="help-block" data-ng-show="addCAppServerForm.appEmailId.$error.required && cv.addCAppServerForm.needsAttention(addCAppServerForm.appEmailId)"><cv:msg key="error.invalidEmailId" bundle="capps" /></span>
									<span class="help-block" data-ng-show="addCAppServerForm.appEmailId.$error.pattern && cv.addCAppServerForm.needsAttention(addCAppServerForm.appEmailId)"><cv:msg key="error.invalidEmailId" bundle="capps" /></span>
								</div>
							</div>
						</div>
						</div></div>
						<!-- Conn End -->
						<div class="panel panel-default">
						<div class="panel-body">
						<!-- General Start-->
						<div data-ng-show="cAppServCtrl.isAddMode">
							<h4 class="margin-0 margin-bottom-10"><cv:msg key="label.cAppClientGeneral" bundle="capps" /></h4>
							<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="clientName"><cv:msg key="label.clientName" bundle="capps" /></label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input type="text" name="clientName" id="clientName" data-ng-model="cAppServCtrl.model.clientName" required />
										<span class="help-block" data-ng-show="cv.addCAppServerForm.needsAttention(addCAppServerForm.clientName)"><cv:msg key="error.clientName" bundle="capps" /></span>
								</div>
							</div>
							<div class="form-group">
								<cv-help-text class="col-xs-12 col-md-4 col-lg-4" help-label="label.backupClientAccNode" help-text="info.accessNode"/>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<select name="backupClient" id="backupClient" data-ng-options="backupClient as backupClient.clientName for backupClient in cAppServCtrl.backupClientList | orderBy: 'clientName'"
									data-ng-model="cAppServCtrl.model.backupClient" required data-ng-change="cAppServCtrl.inputAlerts.backupClient=false">
										<option value=""><cv:msg key="placeholder.backupClientAccNode" bundle="capps"/></option>
									</select>
									<span class="help-block" data-ng-show="cv.addCAppServerForm.needsAttention(addCAppServerForm.backupClient)"><cv:msg key="error.backupClientAccNode" bundle="capps"/></span>
									<span class="help-block" data-ng-show="cAppServCtrl.inputAlerts.backupClient"><cv:msg key="error.backupClient" bundle="capps"/></span>
								</div>
							</div>
							<div class="form-group">
								<cv-help-text class="col-xs-12 col-md-4 col-lg-4" help-label="label.appPrivateKeyPath" help-text="info.gApplicationPrivateKey"/>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<div class="input-group">
										<input type="text" name="appPrivateKeyPath" id="appPrivateKeyPath" data-ng-model="cAppServCtrl.model.appPrivateKeyPath" required data-ng-pattern='pathPattern'/>
										<span class="input-group-btn">
											<button id="addCAppClientContentGAPI_button_#9442" type="button" data-ng-click="cAppServCtrl.browse()" class="btn btn-default browse-btn margin-top-5 margin-left-0"> 
												<cv:msg key="Browse" bundle="storage" />
											</button>
										</span>
									</div>
									<span class="help-block" data-ng-show="cv.addCAppServerForm.needsAttention(addCAppServerForm.appPrivateKeyPath)"><cv:msg key="error.appPrivateKeyPath" bundle="capps"/></span>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="plan"><cv:msg key="label.plan" bundle="capps" /></label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<select name="plan"
											id="plan"
											data-ng-options="profile.planSummary.plan.planId as profile.planSummary.plan.planName for profile in cAppServCtrl.profileList | orderBy: 'planSummary.plan.planName'"
											data-ng-model="cAppServCtrl.model.planId" required>
										<option value=""><cv:msg key="placeholder.plan" bundle="capps"/></option>
									</select>
									<span class="help-block" data-ng-show="cv.addCAppServerForm.needsAttention(addCAppServerForm.plan)"><cv:msg key="error.plan" bundle="capps" /></span>
								</div>
							</div>
						</div>
						<!-- General End-->
						</div></div>
						<!-- Auto discover -->
						<div class="panel panel-default">
						<div class="panel-body">
						<h4 class="margin-0 margin-bottom-10"><cv:msg key="label.cAppClientAutoDiscover" bundle="capps" /></h4>
							<div class="form-group">
								<div class="col-xs-12 col-md-12 col-lg-12">
									<input id="autoDiscover" type="checkbox" data-ng-model="cAppServCtrl.model.autoDiscover" /><label for="autoDiscover"><cv:msg key="label.autoDiscover" bundle="capps" /></label>
								</div>
							</div>
							<div class="form-group" data-ng-disabled="!cAppServCtrl.model.autoDiscover">
								<div class="col-xs-12 col-md-11 col-lg-11 col-md-offset-1 col-lg-offset-1">
									<label for="typeOfAutoDiscoverRegex">
									<input type="radio"
											id="typeOfAutoDiscoverRegex"
											data-ng-model="cAppServCtrl.model.typeOfAutoDiscover"
											value="{{cAppServCtrl.regexText}}"
											name="typeOfAutoDiscover"
											data-ng-checked="cAppServCtrl.model.autoDiscover" /><cv:msg key="label.autoDisc.match.user.regex" bundle="capps" />
									</label>
								</div>
								<div class="col-xs-12 col-md-11 col-lg-11 col-md-offset-1 col-lg-offset-1">
									<label for="typeOfAutoDiscoverGroup">
									<input type="radio"
											id="typeOfAutoDiscoverGroup"
											data-ng-model="cAppServCtrl.model.typeOfAutoDiscover"
											value="{{cAppServCtrl.userGrpText}}"
											name="typeOfAutoDiscover" /><cv:msg key="label.autoDisc.google.grp.affinity" bundle="capps" />
									</label>
								</div>
							</div>
							</div></div>
						<!-- AutoDiscover End-->
						<div class="button-container">
							<button id="addCAppClientContentGAPI_button_#8610" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cAppServCtrl.serverAddCancelled()"> 
							<cv:msg key="Cancel" bundle="messages" />
							</button>
							<button id="addCAppClientContentGAPI_button_#2833" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-show="!cAppServCtrl.hideForm && cAppServCtrl.clientSetupComplete" data-ng-click="cAppServCtrl.skip()"><cv:msg key="Skip" bundle="messages" /></button> 
							<button id="addCAppClientContentGAPI_button_#8635" type="submit" class="btn btn-primary cvBusyOnAjax"> 
								<cv:msg key="Save" bundle="messages" />
							</button>
						</div>
				</form>
				<div class="button-container centered" data-ng-show="cAppServCtrl.hideForm">
					<button id="addCAppClientContentGAPI_button_#8171" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="cAppServCtrl.skip()"><cv:msg key="Continue" bundle="messages" /></button> 
				</div>
			</div><!--// end data-ng-show="cAppServCtrl.showLoading" // -->
		</div><!--// end setup content // -->
		</div><!--// end wrapper div at top // -->
