/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.util.RepConversion;
import oracle.sql.CharacterSet;
import oracle.sql.converter.CharacterSetMetaData;

public class DBConversion {
    public static final boolean DO_CONVERSION_WITH_REPLACEMENT = true;
    public static final short ORACLE8_PROD_VERSION = 8030;
    protected short serverNCharSetId;
    protected short serverCharSetId;
    protected short clientCharSetId;
    protected CharacterSet serverCharSet;
    protected CharacterSet serverNCharSet;
    protected CharacterSet clientCharSet;
    protected CharacterSet asciiCharSet;
    protected boolean isServerCharSetFixedWidth;
    protected boolean isServerNCharSetFixedWidth;
    protected int c2sNlsRatio;
    protected int s2cNlsRatio;
    protected int sMaxCharSize;
    protected int cMaxCharSize;
    protected int maxNCharSize;
    protected boolean isServerCSMultiByte;
    public static final short DBCS_CHARSET = -1;
    public static final short UCS2_CHARSET = -5;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short AL24UTFFSS_CHARSET = 870;
    public static final short UTF8_CHARSET = 871;
    public static final short AL32UTF8_CHARSET = 873;
    public static final short AL16UTF16_CHARSET = 2000;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Thu_Apr__8_03:39:09_PDT_2010";

    public DBConversion(short s, short s2, short s3) throws SQLException {
        if (s2 != -1) {
            this.init(s, s2, s3);
        }
    }

    void init(short s, short s2, short s3) throws SQLException {
        switch (s2) {
            case -5: 
            case 1: 
            case 2: 
            case 31: 
            case 178: 
            case 870: 
            case 871: 
            case 873: {
                break;
            }
            default: {
                DBConversion.unexpectedCharset(s2);
            }
        }
        this.serverCharSetId = s;
        this.clientCharSetId = s2;
        this.serverCharSet = CharacterSet.make(this.serverCharSetId);
        this.serverNCharSetId = s3;
        this.serverNCharSet = CharacterSet.make(this.serverNCharSetId);
        this.clientCharSet = CharacterSet.make(this.clientCharSetId);
        this.c2sNlsRatio = CharacterSetMetaData.getRatio(s, s2);
        this.s2cNlsRatio = CharacterSetMetaData.getRatio(s2, s);
        this.sMaxCharSize = CharacterSetMetaData.getRatio(s, 1);
        this.cMaxCharSize = CharacterSetMetaData.getRatio(s2, 1);
        this.maxNCharSize = CharacterSetMetaData.getRatio(s3, 1);
        this.findFixedWidthInfo();
    }

    void findFixedWidthInfo() throws SQLException {
        this.isServerCharSetFixedWidth = CharacterSetMetaData.isFixedWidth(this.serverCharSetId);
        this.isServerNCharSetFixedWidth = CharacterSetMetaData.isFixedWidth(this.serverNCharSetId);
        this.isServerCSMultiByte = this.sMaxCharSize > 1;
    }

    public short getServerCharSetId() {
        return this.serverCharSetId;
    }

    public short getNCharSetId() {
        return this.serverNCharSetId;
    }

    public boolean IsNCharFixedWith() {
        return this.serverNCharSetId == 2000;
    }

    public short getClientCharSet() {
        if (this.clientCharSetId == -1) {
            return this.serverCharSetId;
        }
        return this.clientCharSetId;
    }

    public CharacterSet getDbCharSetObj() {
        return this.serverCharSet;
    }

    public CharacterSet getDriverCharSetObj() {
        return this.clientCharSet;
    }

    public CharacterSet getDriverNCharSetObj() {
        return this.serverNCharSet;
    }

    public static final short findDriverCharSet(short n, short s) {
        int n2 = 0;
        switch (n) {
            case 1: 
            case 2: 
            case 31: 
            case 178: 
            case 873: {
                n2 = n;
                break;
            }
            default: {
                n2 = s >= 8030 ? 871 : 870;
            }
        }
        return (short)n2;
    }

    public static final byte[] stringToDriverCharBytes(String string, short s) throws SQLException {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        switch (s) {
            case -5: 
            case 2000: {
                byArray = CharacterSet.stringToAL16UTF16Bytes(string);
                break;
            }
            case 1: 
            case 2: {
                byArray = CharacterSet.stringToASCII(string);
                break;
            }
            case 870: 
            case 871: {
                byArray = CharacterSet.stringToUTF(string);
                break;
            }
            case 873: {
                byArray = CharacterSet.stringToAL32UTF8(string);
                break;
            }
            default: {
                DBConversion.unexpectedCharset(s);
            }
        }
        return byArray;
    }

    public byte[] StringToCharBytes(String string) throws SQLException {
        if (string.length() == 0) {
            return null;
        }
        switch (this.clientCharSetId) {
            case -1: {
                return this.serverCharSet.convertWithReplacement(string);
            }
            case 31: 
            case 178: {
                return this.clientCharSet.convertWithReplacement(string);
            }
        }
        return DBConversion.stringToDriverCharBytes(string, this.clientCharSetId);
    }

    public String CharBytesToString(byte[] byArray, int n) throws SQLException {
        return this.CharBytesToString(byArray, n, true);
    }

    public String CharBytesToString(byte[] byArray, int n, boolean bl) throws SQLException {
        String string = null;
        if (byArray.length == 0) {
            return string;
        }
        switch (this.clientCharSetId) {
            case -5: {
                string = CharacterSet.AL16UTF16BytesToString(byArray, n);
                break;
            }
            case 1: 
            case 2: {
                string = new String(byArray, 0, 0, n);
                break;
            }
            case 31: 
            case 178: {
                if (bl) {
                    string = this.clientCharSet.toStringWithReplacement(byArray, 0, n);
                    break;
                }
                string = this.clientCharSet.toString(byArray, 0, n);
                break;
            }
            case 870: 
            case 871: {
                string = CharacterSet.UTFToString(byArray, 0, n, bl);
                break;
            }
            case 873: {
                string = CharacterSet.AL32UTF8ToString(byArray, 0, n, bl);
                break;
            }
            case -1: {
                string = this.serverCharSet.toStringWithReplacement(byArray, 0, n);
                break;
            }
            default: {
                DBConversion.unexpectedCharset(this.clientCharSetId);
            }
        }
        return string;
    }

    public String NCharBytesToString(byte[] byArray, int n) throws SQLException {
        String string = null;
        if (this.clientCharSetId == -1) {
            string = this.serverNCharSet.toStringWithReplacement(byArray, 0, n);
        } else {
            switch (this.serverNCharSetId) {
                case -5: 
                case 2000: {
                    string = CharacterSet.AL16UTF16BytesToString(byArray, n);
                    break;
                }
                case 1: 
                case 2: {
                    string = new String(byArray, 0, 0, n);
                    break;
                }
                case 31: 
                case 178: {
                    string = this.serverNCharSet.toStringWithReplacement(byArray, 0, n);
                    break;
                }
                case 870: 
                case 871: {
                    string = CharacterSet.UTFToString(byArray, 0, n);
                    break;
                }
                case 873: {
                    string = CharacterSet.AL32UTF8ToString(byArray, 0, n);
                    break;
                }
                case -1: {
                    string = this.serverCharSet.toStringWithReplacement(byArray, 0, n);
                    break;
                }
                default: {
                    DBConversion.unexpectedCharset(this.clientCharSetId);
                }
            }
        }
        return string;
    }

    public int javaCharsToCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return this.javaCharsToCHARBytes(cArray, n, byArray, this.clientCharSetId);
    }

    public int javaCharsToCHARBytes(char[] cArray, int n, byte[] byArray, int n2, int n3) throws SQLException {
        return this.javaCharsToCHARBytes(cArray, n, byArray, n2, this.clientCharSetId, n3);
    }

    public int javaCharsToNCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return this.javaCharsToCHARBytes(cArray, n, byArray, this.serverNCharSetId);
    }

    public int javaCharsToNCHARBytes(char[] cArray, int n, byte[] byArray, int n2, int n3) throws SQLException {
        return this.javaCharsToCHARBytes(cArray, n, byArray, n2, this.serverNCharSetId, n3);
    }

    protected int javaCharsToCHARBytes(char[] cArray, int n, byte[] byArray, short s) throws SQLException {
        return this.javaCharsToCHARBytes(cArray, 0, byArray, 0, s, n);
    }

    protected int javaCharsToCHARBytes(char[] cArray, int n, byte[] byArray, int n2, short s, int n3) throws SQLException {
        int n4 = 0;
        switch (s) {
            case -5: 
            case 2000: {
                n4 = CharacterSet.convertJavaCharsToAL16UTF16Bytes(cArray, n, byArray, n2, n3);
                break;
            }
            case 2: 
            case 178: {
                byte[] byArray2 = new byte[n3];
                byArray2 = this.clientCharSet.convertWithReplacement(new String(cArray, n, n3));
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                n4 = byArray2.length;
                break;
            }
            case 1: {
                n4 = CharacterSet.convertJavaCharsToASCIIBytes(cArray, n, byArray, n2, n3);
                break;
            }
            case 31: {
                n4 = CharacterSet.convertJavaCharsToISOLATIN1Bytes(cArray, n, byArray, n2, n3);
                break;
            }
            case 870: 
            case 871: {
                n4 = CharacterSet.convertJavaCharsToUTFBytes(cArray, n, byArray, n2, n3);
                break;
            }
            case 873: {
                n4 = CharacterSet.convertJavaCharsToAL32UTF8Bytes(cArray, n, byArray, n2, n3);
                break;
            }
            case -1: {
                n4 = this.javaCharsToDbCsBytes(cArray, n, byArray, n2, n3);
                break;
            }
            default: {
                DBConversion.unexpectedCharset(this.clientCharSetId);
            }
        }
        return n4;
    }

    public int CHARBytesToJavaChars(byte[] byArray, int n, char[] cArray, int n2, int[] nArray, int n3) throws SQLException {
        return DBConversion._CHARBytesToJavaChars(byArray, n, cArray, n2, this.clientCharSetId, nArray, n3, this.serverCharSet, this.serverNCharSet, this.clientCharSet, false);
    }

    public int NCHARBytesToJavaChars(byte[] byArray, int n, char[] cArray, int n2, int[] nArray, int n3) throws SQLException {
        return DBConversion._CHARBytesToJavaChars(byArray, n, cArray, n2, this.serverNCharSetId, nArray, n3, this.serverCharSet, this.serverNCharSet, this.clientCharSet, true);
    }

    static final int _CHARBytesToJavaChars(byte[] byArray, int n, char[] cArray, int n2, short s, int[] nArray, int n3, CharacterSet characterSet, CharacterSet characterSet2, CharacterSet characterSet3, boolean bl) throws SQLException {
        int n4 = 0;
        int n5 = 0;
        switch (s) {
            case -5: 
            case 2000: {
                n5 = nArray[0] - nArray[0] % 2;
                if (n3 > cArray.length - n2) {
                    n3 = cArray.length - n2;
                }
                if (n3 * 2 < n5) {
                    n5 = n3 * 2;
                }
                n4 = CharacterSet.convertAL16UTF16BytesToJavaChars(byArray, n, cArray, n2, n5, true);
                nArray[0] = nArray[0] - n5;
                break;
            }
            case 1: 
            case 2: {
                n5 = nArray[0];
                if (n3 > cArray.length - n2) {
                    n3 = cArray.length - n2;
                }
                if (n3 < n5) {
                    n5 = n3;
                }
                n4 = CharacterSet.convertASCIIBytesToJavaChars(byArray, n, cArray, n2, n5);
                nArray[0] = nArray[0] - n5;
                break;
            }
            case 31: 
            case 178: {
                n5 = nArray[0];
                n4 = characterSet.toCharWithReplacement(byArray, 0, cArray, n2, n5);
                nArray[0] = nArray[0] - n4;
                break;
            }
            case 870: 
            case 871: {
                if (n3 > cArray.length - n2) {
                    n3 = cArray.length - n2;
                }
                n4 = CharacterSet.convertUTFBytesToJavaChars(byArray, n, cArray, n2, nArray, true, n3);
                break;
            }
            case 873: {
                if (n3 > cArray.length - n2) {
                    n3 = cArray.length - n2;
                }
                n4 = CharacterSet.convertAL32UTF8BytesToJavaChars(byArray, n, cArray, n2, nArray, true, n3);
                break;
            }
            case -1: {
                n4 = DBConversion.dbCsBytesToJavaChars(byArray, n, cArray, n2, nArray[0], characterSet);
                nArray[0] = 0;
                break;
            }
            default: {
                String string;
                char[] cArray2;
                int n6;
                CharacterSet characterSet4 = characterSet3;
                if (bl) {
                    characterSet4 = characterSet2;
                }
                if ((n6 = (cArray2 = (string = characterSet4.toString(byArray, n, nArray[0])).toCharArray()).length) > n3) {
                    n6 = n3;
                }
                System.arraycopy(cArray2, 0, cArray, n2, n6);
            }
        }
        return n4;
    }

    public byte[] asciiBytesToCHARBytes(byte[] byArray) {
        byte[] byArray2 = null;
        switch (this.clientCharSetId) {
            case -5: {
                byArray2 = new byte[byArray.length * 2];
                int n = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    byArray2[n++] = 0;
                    byArray2[n++] = byArray[i];
                }
                break;
            }
            case -1: {
                if (this.asciiCharSet == null) {
                    this.asciiCharSet = CharacterSet.make(1);
                }
                try {
                    byArray2 = this.serverCharSet.convert(this.asciiCharSet, byArray, 0, byArray.length);
                }
                catch (SQLException sQLException) {}
                break;
            }
            default: {
                byArray2 = byArray;
            }
        }
        return byArray2;
    }

    public int javaCharsToDbCsBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        int n2 = this.javaCharsToDbCsBytes(cArray, 0, byArray, 0, n);
        return n2;
    }

    public int javaCharsToDbCsBytes(char[] cArray, int n, byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = 0;
        DBConversion.catchCharsLen(cArray, n, n3);
        String string = new String(cArray, n, n3);
        byte[] byArray2 = this.serverCharSet.convertWithReplacement(string);
        string = null;
        if (byArray2 != null) {
            n4 = byArray2.length;
            DBConversion.catchBytesLen(byArray, n2, n4);
            System.arraycopy(byArray2, 0, byArray, n2, n4);
            byArray2 = null;
        }
        return n4;
    }

    static final int dbCsBytesToJavaChars(byte[] byArray, int n, char[] cArray, int n2, int n3, CharacterSet characterSet) throws SQLException {
        int n4 = 0;
        DBConversion.catchBytesLen(byArray, n, n3);
        String string = characterSet.toStringWithReplacement(byArray, n, n3);
        if (string != null) {
            n4 = string.length();
            DBConversion.catchCharsLen(cArray, n2, n4);
            string.getChars(0, n4, cArray, n2);
            string = null;
        }
        return n4;
    }

    public static final int javaCharsToUcs2Bytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        int n2 = DBConversion.javaCharsToUcs2Bytes(cArray, 0, byArray, 0, n);
        return n2;
    }

    public static final int javaCharsToUcs2Bytes(char[] cArray, int n, byte[] byArray, int n2, int n3) throws SQLException {
        DBConversion.catchCharsLen(cArray, n, n3);
        DBConversion.catchBytesLen(byArray, n2, n3 * 2);
        int n4 = n3 + n;
        int n5 = n2;
        for (int i = n; i < n4; ++i) {
            byArray[n5++] = (byte)(cArray[i] >> 8 & 0xFF);
            byArray[n5++] = (byte)(cArray[i] & 0xFF);
        }
        return n5 - n2;
    }

    public static final int ucs2BytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        return CharacterSet.AL16UTF16BytesToJavaChars(byArray, n, cArray);
    }

    public static final byte[] stringToAsciiBytes(String string) {
        return CharacterSet.stringToASCII(string);
    }

    public static final int asciiBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        return CharacterSet.convertASCIIBytesToJavaChars(byArray, 0, cArray, 0, n);
    }

    public static final int javaCharsToAsciiBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return CharacterSet.convertJavaCharsToASCIIBytes(cArray, 0, byArray, 0, n);
    }

    public static final boolean isCharSetMultibyte(short s) {
        switch (s) {
            case 1: 
            case 31: {
                return false;
            }
            case -5: 
            case -1: 
            case 870: 
            case 871: 
            case 873: {
                return true;
            }
        }
        return false;
    }

    public int getMaxCharbyteSize() {
        return this._getMaxCharbyteSize(this.clientCharSetId);
    }

    public int getMaxNCharbyteSize() {
        return this._getMaxCharbyteSize(this.serverNCharSetId);
    }

    public int _getMaxCharbyteSize(short s) {
        switch (s) {
            case 1: {
                return 1;
            }
            case 31: {
                return 1;
            }
            case 870: 
            case 871: {
                return 3;
            }
            case -5: 
            case 2000: {
                return 2;
            }
            case -1: {
                return 4;
            }
            case 873: {
                return 4;
            }
        }
        return 1;
    }

    public boolean isUcs2CharSet() {
        return this.clientCharSetId == -5;
    }

    public static final int RAWBytesToHexChars(byte[] byArray, int n, char[] cArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            cArray[n2++] = (char)RepConversion.nibbleToHex((byte)(byArray[i] >> 4 & 0xF));
            cArray[n2++] = (char)RepConversion.nibbleToHex((byte)(byArray[i] & 0xF));
        }
        return n2;
    }

    public InputStream ConvertStream(InputStream inputStream, int n) {
        return new OracleConversionInputStream(this, inputStream, n);
    }

    public InputStream ConvertStream(InputStream inputStream, int n, int n2) {
        return new OracleConversionInputStream(this, inputStream, n, n2);
    }

    public InputStream ConvertStream(Reader reader, int n, int n2, short s) {
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this, reader, n, n2, s);
        return oracleConversionInputStream;
    }

    public Reader ConvertCharacterStream(InputStream inputStream, int n) throws SQLException {
        return new OracleConversionReader(this, inputStream, n);
    }

    public Reader ConvertCharacterStream(InputStream inputStream, int n, short s) throws SQLException {
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this, inputStream, n);
        oracleConversionReader.setFormOfUse(s);
        return oracleConversionReader;
    }

    public InputStream CharsToStream(char[] cArray, int n, int n2, int n3) throws SQLException {
        if (n3 == 10) {
            return new AsciiStream(cArray, n, n2);
        }
        if (n3 == 11) {
            return new UnicodeStream(cArray, n, n2);
        }
        DatabaseError.throwSqlException(39, "unknownConversion");
        return null;
    }

    static final void unexpectedCharset(short s) throws SQLException {
        DatabaseError.throwSqlException(35, "DBConversion");
    }

    protected static final void catchBytesLen(byte[] byArray, int n, int n2) throws SQLException {
        if (n + n2 > byArray.length) {
            DatabaseError.throwSqlException(39, "catchBytesLen");
        }
    }

    protected static final void catchCharsLen(char[] cArray, int n, int n2) throws SQLException {
        if (n + n2 > cArray.length) {
            DatabaseError.throwSqlException(39, "catchCharsLen");
        }
    }

    public static final int getUtfLen(char c) {
        int n = 0;
        n = (c & 0xFF80) == 0 ? 1 : ((c & 0xF800) == 0 ? 2 : 3);
        return n;
    }

    int encodedByteLength(String string, boolean bl) {
        int n = 0;
        if (string != null && (n = string.length()) != 0) {
            n = bl ? (this.isServerNCharSetFixedWidth ? n * this.maxNCharSize : this.serverNCharSet.encodedByteLength(string)) : (this.isServerCharSetFixedWidth ? n * this.sMaxCharSize : this.serverCharSet.encodedByteLength(string));
        }
        return n;
    }

    int encodedByteLength(char[] cArray, boolean bl) {
        int n = 0;
        if (cArray != null && (n = cArray.length) != 0) {
            n = bl ? (this.isServerNCharSetFixedWidth ? n * this.maxNCharSize : this.serverNCharSet.encodedByteLength(cArray)) : (this.isServerCharSetFixedWidth ? n * this.sMaxCharSize : this.serverCharSet.encodedByteLength(cArray));
        }
        return n;
    }

    class UnicodeStream
    extends OracleBufferedStream {
        UnicodeStream(char[] cArray, int n, int n2) {
            super(n2);
            this.currentBufferSize = this.initialBufferSize;
            this.resizableBuffer = new byte[this.currentBufferSize];
            int n3 = n;
            int n4 = 0;
            while (n4 < n2) {
                char c = cArray[n3++];
                this.resizableBuffer[n4++] = (byte)(c >> 8 & 0xFF);
                this.resizableBuffer[n4++] = (byte)(c & 0xFF);
            }
            this.count = n2;
        }

        public boolean needBytes() {
            return !this.closed && this.pos < this.count;
        }

        public boolean needBytes(int n) {
            return !this.closed && this.pos < this.count;
        }
    }

    class AsciiStream
    extends OracleBufferedStream {
        AsciiStream(char[] cArray, int n, int n2) {
            super(n2);
            this.currentBufferSize = this.initialBufferSize;
            this.resizableBuffer = new byte[this.currentBufferSize];
            int n3 = n;
            for (int i = 0; i < n2; ++i) {
                this.resizableBuffer[i] = (byte)cArray[n3++];
            }
            this.count = n2;
        }

        public boolean needBytes() {
            return !this.closed && this.pos < this.count;
        }

        public boolean needBytes(int n) {
            return !this.closed && this.pos < this.count;
        }
    }
}

