SELECT  D.DeviceKey, 
        (CASE WHEN LG.ShortLibraryGroupName = 'ODL' THEN 2 ELSE 1 END ) AS LibType, 
        D.DeviceType, 
        D.DeviceSubType,
        D.DeviceTypeName,
        D.DeviceName, 
        D.Description, 
        D.LibraryNumber, 
        D.PrimaryVendorID,
        D.PrimaryProductID,
        D.PrimaryRevision,
        D.SerialNumber,
        D.WorldWideId, 
        MD.PrimaryPath,
        D.DriveCount, 
        (SELECT FQMachineName FROM EMM_MAIN.EMM_Machine WHERE MachineKey = MD.PrimaryMachineKey ),
        (SELECT MachinePrimaryName FROM EMM_MAIN.EMM_Machine WHERE MachineKey = MD.PrimaryMachineKey ),  
        (SELECT FQMachineName FROM EMM_MAIN.EMM_Machine WHERE MachineKey = MD.SecondaryMachineKey ),
        (SELECT MachinePrimaryName FROM EMM_MAIN.EMM_Machine WHERE MachineKey = MD.SecondaryMachineKey ),
        D.ControlHostName, 
        (SELECT max(SlotNumber) FROM EMM_MAIN.EMM_Media WHERE LibraryNumber = D.LibraryNumber) AS NumberOfSlots, 
 	    (CASE WHEN MD.DeviceStatus = '1' THEN 1 ELSE 0 END) as Status	
FROM    EMM_MAIN.EMM_Device D 
        INNER JOIN EMM_MAIN.EMM_MachineDeviceConnection MD ON MD.DeviceKey = D.DeviceKey 
        LEFT OUTER JOIN EMM_MAIN.EMM_LibraryGroup LG ON LG.LibraryGroupName = D.DeviceTypeName 
WHERE       D.LibraryNumber >= 0 
        AND D.DriveParentKey = 0 
GO

