SELECT  M.MediaKey,                 
        M.DriveKey,                 
        M.MediaTypeName,            
        M.Barcode,                  
        M.ManufacturerName,         
        M.SerialNumber,             
        M.SlotNumber,               
        (SELECT D.DeviceName FROM EMM_MAIN.EMM_Device D WHERE D.DeviceKey = M.DriveKey) as LocationName,  
        M.MediaId,                  
        (CASE WHEN MD.LibraryNumber = -1 THEN 'Unknown' ELSE MD.DeviceName END) AS DeviceName, 
        (CASE WHEN LG.ShortLibraryGroupName = 'ODL' THEN 2 ELSE 1 END ) AS LibType,         
        datediff(second, '1970-01-01 00:00:00.000', M.LastWriteDateTime) AS LastWriteTime,  
        datediff(second, '1970-01-01 00:00:00.000', M.LastRestoreDateTime) AS LastReadTime, 
        CONVERT (BIGINT,  M.TotalWriteKBytes * 1024) AS TotalOccupied,                      
        M.TotalMounts,              
        MA.MachinePrimaryName,      
        M.MediaRunTimeStatus,       
        (CASE M.MediaRunTimeStatus WHEN 1 THEN 'NBU Frozen Media' WHEN 2 THEN 'NBU Suspended Media' ELSE '' END) 
FROM    EMM_MAIN.EMM_Media M         
        INNER   JOIN EMM_MAIN.EMM_MediaGroup MG ON MG.MediaGroupName = M.MediaGroupName          
        INNER   JOIN EMM_MAIN.EMM_Device MD ON MD.LibraryNumber = MG.LibraryNumber               
        INNER   JOIN EMM_MAIN.EMM_Machine MA ON MA.MachineKey = MD.ControlHostKey                
        LEFT OUTER JOIN EMM_MAIN.EMM_LibraryGroup LG ON LG.LibraryGroupName = MD.DeviceTypeName  
WHERE   MD.DriveParentKey = 0 

GO
