SET NOCOUNT ON
SELECT  D.DeviceKey,         
        D.DeviceName,        
        D.Description,       
        D.PrimaryVendorID,   
        D.PrimaryProductID,  
        D.PrimaryRevision,   
        D.SerialNumber,      
        D.WorldWideId,       
        D.DriveElementIndex, 
        MD.PrimaryPath,     
        (SELECT MachinePrimaryName FROM EMM_MAIN..EMM_Machine WHERE MachineKey = MD.PrimaryMachineKey ),   
        (SELECT MachinePrimaryName FROM EMM_MAIN..EMM_Machine WHERE MachineKey = MD.SecondaryMachineKey ), 
        (CASE WHEN MD.DeviceStatus = '2' THEN 1 ELSE 0 END) as Status,                                    
        D.DeviceTypeName,	 
        D.DriveParentKey,    
        0 AS StubColumn      
FROM    EMM_MAIN..EMM_Device D 
        INNER JOIN EMM_MAIN..EMM_MachineDeviceConnection MD ON MD.DeviceKey = D.DeviceKey

GO

